/**********************************************************************
*
* autolaunch menu.c -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements menus in the
* autolaunch program.
*
**********************************************************************/

#include <types.h>
#include <window.h>
#include <event.h>
#include <menu.h>
#include <desk.h>
#include <intmath.h>
#include <resources.h>
#include <stdfile.h>

#include "autolaunch.h"

void	appSetMenus();
void	doMenuCommand();
void	chooseTriggerFile();
void	chooseTargetFile();
void	invalOneCtl();

/**********************************************************************/

void	doQuitItem()
{
	quitFlag++;
}

/**********************************************************************/

void			setMItem(id, flag)
unsigned int	id, flag;
{
	if (flag) EnableMItem(id);
	else      DisableMItem(id);
}

/**********************************************************************/

void	doAboutItem()
{
	WindowPtr		wptr, keepPort;
	unsigned long	id;
	unsigned int	item;

	zapLocals();

	keepPort = GetPort();

	wptr = NewWindow2(NULL, NULL, NULL, NULL, 2, AboutWindowID, rWindParam1);
	if (!_toolErr) {
		aboutWindow = wptr;
		for (;;) {
			doNetCheck(0);
			if (quitFlag) break;

			id = fakeModalDialog(&event, NULL, NULL, NULL,
				fmdMenuSelect+
				fmdMenuKey+
				fmdDeskAcc+
				fmdUpdateAll
			);
			item = id;								/* Get lo-word. */
			if (id & 0x80000000L) {					/* If menu command... */
				if (item == 255) {
					HiliteMenu(0, FileMenuID);		/* Nobody else is going to.		  */
					break;							/* If close, close the about box. */
				}
				doMenuCommand(id);
				if (quitFlag) break;
			}
			else if (item == 1) break;				/* ...else handle controls. */
		}
	
		SetPort(keepPort);
		CloseWindow(wptr);
		aboutWindow = NULL;
		appSetMenus();
	}
}

/**********************************************************************/

void			doMenuCommand(id)
unsigned long	id;
{
	unsigned int	menuNum, itemNum;

	zapLocals();

	menuNum = HiWord(id) & 0x7FFF;
	itemNum = LoWord(id);

	switch (itemNum) {

		case AboutItem:
			HiliteMenu(0, AppleMenuID);		/* Unhighlight the menu title first. */
			menuNum = 0;					/* Don't unhilight again. */
			doAboutItem();
			break;

		case QuitItem:
			doQuitItem();
			break;

		case ChooseTriggerItem:
			chooseTriggerFile();
			break;

		case ChooseTargetItem:
			chooseTargetFile();
			break;

		case SaveLaunchItem:
			saveLaunchInfo();
			break;

		case UndoItem:
		case CutItem:
		case CopyItem:
		case PasteItem:
		case ClearItem:
		case CloseItem:
			break;
	}

	if (menuNum) HiliteMenu(0, menuNum);		/* Unhighlight the menu title. */
}

/**********************************************************************/

void	setupMenus()
{
	/* Procedure to install our menu titles and their items in the system menu
	** bar and to redraw it so we can see them.
	*/

	SetSysBar(NewMenuBar2(refIsResource, 0x0001L, NULL));
	SetMenuBar(NULL);
	
	FixAppleMenu(AppleMenuID);				/* Add DAs to apple menu	 */
	FixMenuBar();							/* Set sizes of menus		 */
	DrawMenuBar();							/* ...and draw the menu bar! */

	DisableMItem(UndoItem);
	fmdSetMenuProc(appSetMenus);
}

/**********************************************************************/

void	appSetMenus()
{
	unsigned int	about, frontIsDA, i;

	zapLocals();

	about = frontIsDA = 0;

	if (aboutWindow) about++;
	if (GetWKind(FrontWindow()) & 0x8000) frontIsDA++;

	setMItem(AboutItem, !about);
		/* If about isn't already open, then allow it to be opened. */

	setMItem(CloseItem, i = (about | frontIsDA));
		/* If we have an about box or DA, then allow close. */

	setMItem(ChooseTriggerItem, i = !i);
	setMItem(ChooseTargetItem, i);

	if (!frontIsDA) DisableMItem(UndoItem);
}

/**********************************************************************/

void	chooseTriggerFile()
{
	SFReplyRec2		myReply;

	myReply.nameRefDesc = myReply.pathRefDesc = refIsNewHandle;
	SFGetFile2(					/* Do an incredibly ordinary SFGetFile2. */
		80, 32,
		refIsPointer,
		"\pChoose a Trigger File",
		NULL,
		NULL,
		&myReply
	);

	if (myReply.good) {			/* User did pick something... */
		BlockMove(*(char **)myReply.pathRef + 2, launch.triggerPath, 514L);
		DisposeHandle(myReply.pathRef);

		BlockMove(*(char **)myReply.nameRef + 2, launch.triggerName, 34L);
		DisposeHandle(myReply.nameRef);

		updateControls();
		invalOneCtl(GetCtlHandleFromID(mainWindow, AppTriggerData));

		getFileInfo();
		launch.dates[0] = launch.dates[2];
		launch.dates[1] = launch.dates[3];
	}
}

/**********************************************************************/

void	chooseTargetFile()
{
	SFReplyRec2		myReply;

	myReply.nameRefDesc = myReply.pathRefDesc = refIsNewHandle;
	SFGetFile2(					/* Do an incredibly ordinary SFGetFile2. */
		80, 32,
		refIsPointer,
		"\pChoose a Target Launch File",
		NULL,
		NULL,
		&myReply
	);

	if (myReply.good) {			/* User did pick something... */
		BlockMove(*(char **)myReply.pathRef + 2, launch.targetPath, 514L);
		DisposeHandle(myReply.pathRef);

		BlockMove(*(char **)myReply.nameRef + 2, launch.targetName, 34L);
		DisposeHandle(myReply.nameRef);

		updateControls();
		invalOneCtl(GetCtlHandleFromID(mainWindow, AppTargetData));
	}
}

/**********************************************************************/

void		invalOneCtl(ctlHndl)
CtlRecHndl	ctlHndl;
{
	GrafPortPtr	keepPort;
	CtlRecPtr	ctlPtr;
	Rect		rct, *rctPtr;

	ctlPtr = *ctlHndl;

	keepPort = GetPort();
	SetPort(ctlPtr->ctlOwner);
	
	rctPtr = &(ctlPtr->ctlRect);
	rct.v1 = rctPtr->v1;
	rct.h1 = rctPtr->h1;
	rct.v2 = rctPtr->v2;
	rct.h2 = rctPtr->h2;

	InvalRect(&rct);
	SetPort(keepPort);
}

